
import cadquery as cq

# Set dimensions
height = 5
main_length = 20
main_width = 10
tab_width = 2
tab_length = 5
hole_diameter = 6
tab_cutout_length = 3
tab_cutout_width = 1.5

# Create the base rectangle
base = cq.Workplane("XY").rect(main_length, main_width).extrude(height)

# Add tabs on the longer sides of the rectangle
tab1 = (base.faces(">X").workplane(centerOption="CenterOfBoundBox")
        .rect(tab_width, tab_length, centered=False).extrude(height, combine=True))

tab2 = (tab1.faces("<X").workplane(centerOption="CenterOfBoundBox")
        .rect(tab_width, tab_length, centered=False).extrude(height, combine=True))

# Cutouts for the tabs to make a puzzle piece look
tab_cutout1 = (tab1.faces(">X").workplane(centerOption="CenterOfBoundBox")
               .center(tab_width / 2, 0).rect(tab_cutout_width, tab_cutout_length)
               .cutThruAll())

tab_cutout2 = (tab_cutout1.faces("<X").workplane(centerOption="CenterOfBoundBox")
               .center(-tab_width / 2, 0).rect(tab_cutout_width, tab_cutout_length)
               .cutThruAll())

# Create a hole in the center of the object
final_result = tab_cutout2.faces(">Z").workplane().hole(hole_diameter)

# Export STL
final_result.val().exportStl("Refine_V_2.stl")
