
import cadquery as cq

length = 100.0  # Total length of the wrench
width = 20.0    # Width of the handle
thickness = 5.0  # Thickness of the wrench
small_radius = 25.0  # Radius of the smaller circular end
large_radius = 30.0  # Radius of the larger circular end
small_hole_radius = 7.0  # Radius of the hole in the smaller circular end
large_hole_radius = 9.0  # Radius of the hole in the larger circular end
handle_length = length - (small_radius + large_radius)  # Length of the handle part

# Create the base shape
result = (cq.Workplane("XY")
          .rect(handle_length, width)  # Create the rectangle for the handle
          .moveTo(-handle_length/2 - large_radius, 0)
          .circle(large_radius)  # Create the larger circle on one end
          .moveTo(handle_length/2 + small_radius, 0)
          .circle(small_radius)  # Create the smaller circle on the other end
          .consolidateWires()  # Combine all edges into a single wire for extrusion
          .extrude(thickness))

# Cut out holes
result = (result.faces(">Z")
          .workplane()
          .pushPoints([(-length / 2 + large_radius, 0), (length / 2 - small_radius, 0)])
          .hole(large_hole_radius * 2)
          .hole(small_hole_radius * 2))

# Export to STL
result.val().exportStl("Refine_V_2.stl")
