
import cadquery as cq

# Parameters
diameter = 100.0
height = 20.0
center_hole_diameter = diameter / 8
small_hole_diameter = center_hole_diameter / 3  # smaller than the central hole
small_hole_offset = center_hole_diameter * 1.5  # reposition to ensure clear triangular formation

# Main cylinder
result = cq.Workplane("XY").circle(diameter / 2).extrude(height)

# Central hole
result = result.faces(">Z").workplane().hole(center_hole_diameter)

# Adding three smaller holes in a triangular formation
for angle in [0, 120, 240]:
    result = result.faces(">Z").workplane().\
        transformed(rotate=(0, 0, angle)).\
        center(small_hole_offset, 0).\
        hole(small_hole_diameter)

# Export the modified design
result.val().exportStl("Refine_V_1.stl")
