
import cadquery as cq

# Define the dimensions for the cylinder and holes
diameter = 100.0  # Diameter of the cylinder
height = 20.0     # Height of the cylinder
center_hole_diameter = diameter / 8  # Diameter of the central hole, 1/8th of the cylinder's diameter

# Define the dimensions for the smaller holes
small_hole_diameter = center_hole_diameter / 3  # Diameter of the smaller holes
small_hole_offset = center_hole_diameter * 1.5  # Offset from the center for the smaller holes

# Create the base cylinder
result = cq.Workplane("XY").circle(diameter / 2).extrude(height)

# Create the central hole through the cylinder
result = result.faces(">Z").workplane().hole(center_hole_diameter)

# Create three smaller holes in a triangular formation
for angle in [0, 120, 240]:
    result = result.faces(">Z").workplane() \
        .transformed(rotate=(0, 0, angle)) \
        .center(small_hole_offset, 0) \
        .hole(small_hole_diameter)

# Export the final model to an STL file
result.val().exportStl("Refine_V_2.stl")
