
import cadquery as cq

# Define the dimensions of the rectangle and the holes
length = 100.0  # Length of the rectangle
width = 50.0  # Width of the rectangle
thickness = 10.0  # Thickness of the rectangle
hole_diameter = 5.0  # Diameter of the holes

# Create the rectangle
result = (
    cq.Workplane("XY")
    .box(length, width, thickness)
)

# Create the holes
for i in range(3):
    result = (
        result.faces(">Z")
        .workplane()
        .center(length / 4, (i - 1) * width / 4)
        .hole(hole_diameter)
    )

# Export the result
result.val().exportStl("Generated.stl")
