
import cadquery as cq

# Parameters
length = 100.0
width = 50.0
thickness = 10.0
hole_diameter = 5.0

# Create the main body of the rectangle
result = (
    cq.Workplane("XY")
    .box(length, width, thickness)
)

# Place three holes aligned with the shorter side of the rectangle
for i in range(3):
    result = (
        result.faces(">Z")
        .workplane()
        .center(length / 4, width / 4 - i * (width / 4))
        .hole(hole_diameter)
    )

# Export the refined model to an STL file
result.val().exportStl("Refine_V_1.stl")
