
import cadquery as cq

# Define dimensions for rectangular prism
base_length = 15  # Increased to create a rectangular shape
base_width = 10
base_height = 5

# Define dimensions for slot, kept the same as there's no feedback to change these
slot_length = 5
slot_width = 5
slot_depth = 3

# Create the base of the rectangular prism
base = cq.Workplane("XY").rect(base_length, base_width).extrude(base_height)

# Create slot within the rectangular prism
slot = base.faces(">Z").workplane().rect(slot_length, slot_width).cutBlind(-slot_depth)

# Export the refined model
slot.val().exportStl("Refine_V_2.stl")
