
import cadquery as cq

# Create a rectangle
result = cq.Workplane("front").rect(10, 2)

# Extrude the sketch
result = result.extrude(1)

# Fillet two corners
result = result.edges("|Z").fillet(0.3)

# Verify it's in a 3D solid shape
if result.solids().size() > 0:
    result = result.solids().first()

# Save the output
result.val().exportStl("Generated.stl")
