
import cadquery as cq

block_width = 20.0  # Width of the block is set as 20 units.
block_height = 10.0  # Height of the block is clearly half of the width, as required.
block_depth = block_height / 4  # Depth of the block is 1/4th of its height.

hole_width = block_width * 5 / 12  # Correct width for each hole: 5/12th of the block's width.
hole_height = block_height * 7 / 10  # Correct height for each hole: 7/10th of the block's height.
hole_radius = 1.0  # Radius for filleting the corners of the holes

# Creating the main block
block = cq.Workplane("front").rect(block_width, block_height).extrude(block_depth)

# Creating the holes with rounded corners
holes = (
    cq.Workplane("front")
    .workplane(offset=block_depth/2)  # Ensuring holes start from the middle of the block's depth
    .moveTo(-block_width / 4, 0)  # Positioning the first hole
    .rect(hole_width, hole_height, radius=hole_radius)  # Adding rounded corners
    .cutBlind(-block_depth)  # Cutting the holes through the block
)

# Mirroring the first hole to the other side of the block
holes = holes.union(
    cq.Workplane("front")
    .workplane(offset=block_depth/2)
    .moveTo(block_width / 4, 0)
    .rect(hole_width, hole_height, radius=hole_radius)
    .cutBlind(-block_depth)
)

# Final result after cutting holes from the block
result = block.cut(holes)

# Export to STL with the new file name to indicate the updated version
result.val().exportStl("Refine_V_2.stl")
