
import cadquery as cq

length = 80
width = 20
thickness = 5
cutout_side = 10
cutout_fillet_radius = 2

# Create the base rectangular plate
plate = cq.Workplane("XY").box(length, width, thickness)

# Define a function to create a cutout with rounded edges
def create_cutout(origin_x):
    return (cq.Workplane("XY", origin=(origin_x, width/2, 0))
            .rect(cutout_side, cutout_side)
            .extrude(-thickness)
            .edges("|Z")
            .fillet(cutout_fillet_radius))

# Create cutouts at the correct locations based on feedback
cutout1 = create_cutout(cutout_side/2)
cutout2 = create_cutout(length - cutout_side/2)

# Cut the cutouts from the base plate
result = plate.cut(cutout1).cut(cutout2)

# Export the final model to STL
result.val().exportStl("Refine_V_2.stl")
