
import cadquery as cq

base_small = 10.0
base_large = 20.0
height = 15.0
extrude_amount = 200.0  # Increased for elongation

# Creating a sketch of an isosceles trapezium
r = cq.Workplane("front")\
    .lineTo(base_small / 2, 0)\
    .lineTo(base_large / 2, height)\
    .lineTo(-base_large / 2, height)\
    .lineTo(-base_small / 2, 0)\
    .close()

# Extruding the trapezium to form the prism
result = r.extrude(extrude_amount)

# Saving the result as STL file
result.val().exportStl("Refine_V_1.stl")
