
import cadquery as cq

length_vertical = 100.0   # Length of the vertical rectangle
width = 20.0              # Width, which is common for both horizontal and vertical rectangles
thickness = 5.0           # Thickness of extrusion for both rectangles
length_horizontal = length_vertical / 4   # Length of the horizontal rectangle

# Creating the main vertical part of the T
vertical_part = cq.Workplane("front").rect(width, length_vertical).extrude(thickness)

# Positioning for the horizontal part to make a perfect T-shape
horizontal_position = -length_vertical / 2 + 10  # Adjusted to place correctly on top of the vertical part

# Adding the horizontal part on top of the vertical rectangle
t_shape = vertical_part.faces(">Z").workplane(centerOption="CenterOfBoundBox").transformed(offset=(0, horizontal_position, 0)).rect(width, length_horizontal).extrude(thickness)

# Exporting the final model
t_shape.val().exportStl("Refine_V_2.stl")
