
import cadquery as cq

# Parameters for the triangle and hole
base_length = 10.0
height = 15.0
corner_radius = 1.0
hole_radius = 0.2

# Create the base triangle on XY plane
result = (
    cq.Workplane("XY")
    .moveTo(-base_length / 2, 0)
    .lineTo(base_length / 2, 0)
    .lineTo(0, height)
    .close()
)

# Extrude to 3D
result = result.extrude(1.0)  # Extrude in the positive direction

# Round the bottom corners
result = (
    result.edges("<Z")  # Select all edges below the Z=0 plane
    .fillet(corner_radius)
)

# Add the hole
result = (
    result.faces(">Z")
    .workplane()
    .hole(hole_radius, depth=None, clean=True)
)

# Export the result
result.val().exportStl("Generated.stl")
