
import cadquery as cq

# Define the points to form an irregular pentagon where the bottom edge is shortest
points = [(0, 0), (2, 1), (1.5, 3), (-1.5, 3), (-2, 1)]

# Create a workplane to draw the pentagon
r = cq.Workplane("front").polyline(points).close()

# Define the height of the pentagon as the vertical distance between the lowest and highest points
pent_height = 3  # maximum y-coordinate difference

# Adjust extrusion height to be almost two times the height of the pentagon
extrusion_height = 1.8 * pent_height

# Extrude the sketch
result = r.extrude(extrusion_height)

# Export the result to a STL file
result.val().exportStl("Refine_V_2.stl")
