
import cadquery as cq
import math

side_length = 10.0

# Calculating the height of an equilateral triangle
height = side_length * math.sqrt(3) / 2

# Calculating the radius of the semicircle
radius = (side_length * 2 / 3) / 2

# Points for the equilateral triangle 
pts = [
    (-side_length / 2, -height / 2),
    (side_length / 2, -height / 2),
    (0, height / 2)
]

# Base triangle
result = cq.Workplane("front").polyline(pts).close()

# Creating a semicircular cutout at the bottom
# Moving to center at the bottom edge of the triangle and creating a semicircle
result = result.moveTo(0, -height / 2).circle(radius).extrude(10.0)

# Final extrusion of the triangle to 3D after adding the semicircle cutout
result = result.cut(
    cq.Workplane("front").moveTo(0, -height / 2).circle(radius).extrude(10.0)
)

# Exporting the result to STL file
result.val().exportStl("Refine_V_1.stl")
