
import cadquery as cq
import math

# Specifications for the equilateral triangle
side_length = 10.0
height = side_length * (math.sqrt(3) / 2)  # Height of an equilateral triangle

# Semicircle cutout diameter specification
radius = (side_length * 2 / 3) / 2  # Radius is half of 2/3rd of the side length

# Coordinates for the vertices of the equilateral triangle
pts = [
    (-side_length / 2, -height / 2),
    (side_length / 2, -height / 2),
    (0, height / 2)
]

# Create the workplane and triangle using polyline and close to complete the sketch
result = cq.Workplane("front").polyline(pts).close()

# Move to the center position for cutting and draw a circle for the semicircular cutout
result = result.moveTo(0, -height / 2).circle(radius)

# Next, extrude the sketch (triangle with the semicircular area preparation)
extruded_triangle = result.extrude(10.0)

# To cut out the semicircular part from the extruded solid triangle
cut_out_semi = (
    cq.Workplane("front")
    .moveTo(0, -height / 2)
    .circle(radius)
    .extrude(10.0)
)

# Perform the cut to create the final 3D object
final_result = extruded_triangle.cut(cut_out_semi)

# Export the final result to an STL file
final_result.val().exportStl("Refine_V_2.stl")
