
import cadquery as cq

# Define the dimensions for the box
base_width = 20.0
base_height = 10.0
base_depth = 1.0
wall_thickness = 1.0
wall_height = 10.0
chamfer_size = 0.5

# Create the base of the box
base = cq.Workplane("XY").rect(base_width, base_height).extrude(base_depth)

# Create walls on the base
# The inner rectangle should be smaller by twice the wall thickness from each edge
walls = (
    base.faces(">Z")
    .workplane()
    .rect(base_width, base_height)
    .rect(base_width - 2 * wall_thickness, base_height - 2 * wall_thickness)
    .extrude(wall_height)
)

# Apply chamfer to the inside edges of the walls
chamfer_size = min(chamfer_size, wall_thickness)  # ensure the chamfer size is not larger than the wall thickness
walls = walls.edges("|Z and >X").chamfer(chamfer_size)
walls = walls.edges("|Z and <X").chamfer(chamfer_size)
walls = walls.edges("|Z and >Y").chamfer(chamfer_size)
walls = walls.edges("|Z and <Y").chamfer(chamfer_size)

# Combine the base and walls to create the final box
box = base.union(walls)

# Export the final 3D model to an STL file
box.val().exportStl("Refine_V_1.stl")
