
import cadquery as cq

length = 10.0  # Length of the blocks
width1 = 5.0  # Width of the lower block
width2 = 3.0  # Width of the upper block that now matches the full length of the lower block
height = 2.0  # Height of each block
hole_diameter = 1.0  # Diameter of the hole

# Create lower rectangular block
result = cq.Workplane("XY").rect(length, width1).extrude(height)

# Create upper rectangular block, ensuring it spans the entire length of the lower block
result = result.faces(">Z").workplane().rect(length, width2).extrude(height)

# Create a circular hole that extends through both the upper and lower blocks at their center
result = result.faces(">Z").workplane().center(0, 0).circle(hole_diameter / 2).cutThruAll()

# Save the model
result.val().exportStl("Refine_V_1.stl")
