
import cadquery as cq

# Specifying dimensions based on the requirements
height = 10.0
width = 3 * height  # Width is three times the height
depth = 2.0

# Specific dimensions for the cutouts
cutout_width = 2.0
cutout_height_right = 2.0
cutout_height_left = cutout_height_right * 3  # Left cutout is three times longer than the right cutout

# Create the base rectangular prism
result = cq.Workplane("front").rect(width, height).extrude(depth)

# Create left cutout
result = result.faces("<X").workplane().center(width/2 - cutout_width/2, 0).rect(cutout_width, cutout_height_left).cutBlind(-depth)

# Create right cutout
result = result.faces(">X").workplane().center(-width/2 + cutout_width/2, 0).rect(cutout_width, cutout_height_right).cutBlind(-depth)

# Export to STL file
result.val().exportStl("Refine_V_1.stl")
