
import cadquery as cq

# Define dimensions
height = 10.0
width = 3 * height
depth = 2.0

# Define custom dimensions for cutouts
cutout_width = 2.0
cutout_height_right = 2.0  # Height of the right cutout
cutout_height_left = cutout_height_right * 3  # Left cutout is three times longer than the right

# Create the main rectangle and extrude it
result = cq.Workplane("front").rect(width, height).extrude(depth)

# Left cutout
result = result.faces("<X").workplane().center(width/2 - cutout_width/2, 0) \
                 .rect(cutout_width, cutout_height_left).cutBlind(-depth)

# Right cutout
result = result.faces(">X").workplane().center(-width/2 + cutout_width/2, 0) \
                 .rect(cutout_width, cutout_height_right).cutBlind(-depth)

# Save the output
result.val().exportStl("Refine_V_2.stl")
