
import cadquery as cq
import math

# Specifications
base_length = 10.0
top_length = 5.0
height = 7.0
extrude_amount = 2.0

# Derived geometric properties
base_angle_deg = 70
base_angle_rad = math.radians(base_angle_deg)

# Calculate the length of the side edges
# Using the law of cosines: side length calculation considering the angles
delta_x = (base_length - top_length) / 2
side_length = delta_x / math.cos(base_angle_rad)
vertical_height = side_length * math.sin(base_angle_rad)

# Calculate the coordinates based on modified side length and top position
x1, y1 = -base_length / 2, 0
x2, y2 = -top_length / 2, vertical_height
x3, y3 = top_length / 2, vertical_height
x4, y4 = base_length / 2, 0

# Creating the trapezoid plate in in CADQuery
result = (cq.Workplane("front")
          .moveTo(x1, y1)
          .lineTo(x2, y2)
          .lineTo(x3, y3)
          .lineTo(x4, y4)
          .close()
          .extrude(extrude_amount))

# Export the result to an STL file
result.val().exportStl("Refine_V_2.stl")
