
import cadquery as cq

# Define the base rhombus, ensuring equal side lengths and closed topology
base_length = 4.0
rhombus = cq.Workplane("front").polyline([(0, 0), (base_length, 2), (2*base_length, 0), (base_length, -2)]).close()
rhombus_body = rhombus.extrude(0.5)  # Extrusion of the base rhombus

# Define the rectangular prism and place it centered along one edge
prism_width, prism_depth, prism_height = 1.5, 4.0, 1.0
rect_prism = cq.Workplane("front").box(prism_depth, prism_width, prism_height).translate((base_length, 0, 0.5))

# Create the arm of the excavator
arm_length = 6
arm_width = 0.5
excavator_arm = cq.Workplane("top").box(arm_length, arm_width, 0.4).translate((base_length + (arm_length/2), 0, 1))

# Create the bucket
bucket = cq.Workplane("top").box(2, 1.5, 1).rotate((0,0,1), (0,0,0), 45).translate((base_length + arm_length, 0, 1))

# Create tracks for the excavator
track = cq.Workplane("front").box(0.2, base_length + 1, 0.7).translate((base_length, 0, -0.35))

# Combine all the components
result = rhombus_body.union(rect_prism)
result = result.union(excavator_arm)
result = result.union(bucket)
result = result.union(track.mirror("XZ").union(track))

# Final output of the model as STL
result.val().exportStl("Refine_V_1.stl")
