
import cadquery as cq

# Define basic parameters
base_length = 4.0

# Create the base rhombus shape and extrude it
rhombus = cq.Workplane("front").polyline([(0, 0), (base_length, 2), (2*base_length, 0), (base_length, -2)]).close()
rhombus_body = rhombus.extrude(0.5)

# Create and position the rectangular prism (representing the cab of the excavator)
prism_width, prism_depth, prism_height = 1.5, 4.0, 1.0
rect_prism = cq.Workplane("front").box(prism_depth, prism_width, prism_height).translate((base_length, 0, 0.5))

# Create the excavator arm
boom_length = 6 
boom_width = 0.5
excavator_arm = cq.Workplane("top").box(boom_length, boom_width, 0.4).rotate((0,0,1), (0,0,0), 20).translate((base_length + (boom_length / 2), 0, 1.3))

# Redesign the bucket for more realistic shape
bucket = cq.Workplane("top").box(2, 1, 1).rotate((0,0,1), (0,0,0), 45).translate((base_length + boom_length, 0, 1.3))

# Create tracks widened to enhance stability appearance
track = cq.Workplane("front").box(0.25, base_length + 1.2, 0.7).translate((base_length, 0, -0.35))

# Union all parts together
result = rhombus_body.union(rect_prism)
result = result.union(excavator_arm)
result = result.union(bucket)
result = result.union(track.mirror("XZ").union(track))

# Export final model to STL file
result.val().exportStl("Refine_V_2.stl")
