Hyperbolic Graph Convolutional Network (SRBGCN)
======================================================

This repository includes the implementations of SRBGCN for the link prediction and node classification tasks in PyTorch. 



### For node classification, run
'''
python train.py --task nc --dataset disease_nc --model SRBGCN --log-freq 20 --lr_scheduler step --epochs 5000 --step_lr_reduce_freq 500 --feature_dim 1000 --tie_weight 0 --lr 0.005  --num_centroid 200 --dim 8 --num-layers 6 --hyp_rotation 1 --cuda 0 --step_lr_gamma 0.8

python train.py --task nc --dataset airport --model SRBGCN --log-freq 20 --lr_scheduler step --epochs 5000 --step_lr_reduce_freq 500 --feature_dim 11 --tie_weight 0 --lr 0.2 --num_centroid 100 --dim 16 --num-layers 2 --hyp_rotation 1 --cuda 0 --dropout 0.6 --normalize-feats 0 --step_lr_gamma 0.8

python train.py --task nc --dataset pubmed --model SRBGCN --log-freq 20 --lr_scheduler step --epochs 5000 --step_lr_reduce_freq 500 --feature_dim 500 --tie_weight 0 --lr 0.04 --num_centroid 100 --dim 16 --num-layers 5 --hyp_rotation 1 --cuda 0 --margin 1 --dropout 0.8 --weight-decay 0.01

python train.py --task nc --dataset cora --model SRBGCN --log-freq 20 --lr_scheduler step --epochs 5000 --step_lr_reduce_freq 500 --feature_dim 1433 --tie_weight 0 --lr 0.001 --num_centroid 200 --dim 16 --num-layers 3 --hyp_rotation 0 --cuda 0 --dropout 0.9 --weight-decay 0.01 --step_lr_gamma 0.8
'''

### For link prediction, run
'''
python train.py --task lp --dataset disease_lp --model SRBGCN --log-freq 20 --lr_scheduler step --epochs 5000 --step_lr_reduce_freq 5000 --feature_dim 11 --tie_weight 1 --lr 0.001 --dim 16 --num-layers 2 --cuda 0 --hyp_rotation 1 --normalize-feats 0 --patience 1000

python train.py --task lp --dataset airport --model SRBGCN --log-freq 20 --lr_scheduler step --epochs 5000 --step_lr_reduce_freq 500 --feature_dim 12 --tie_weight 1 --lr 0.5 --dim 16 --num-layers 1  --cuda 0 --dropout 0.0 --weight-decay 0.00001 --margin 0.1 --step_lr_gamma 0.9

python train.py --task lp --dataset pubmed --model SRBGCN --log-freq 20 --lr_scheduler step --epochs 5000 --step_lr_reduce_freq 500 --feature_dim 500 --tie_weight 1 --lr 0.05 --dim 16 --num-layers 1 --cuda 0 --dropout 0.5 --weight-decay 0 --margin 0.1 --step_lr_gamma 0.8

python train.py --task lp --dataset cora --model SRBGCN --log-freq 20 --lr_scheduler step --epochs 5000 --step_lr_reduce_freq 500 --feature_dim 1433 --tie_weight 1 --lr 0.001 --dim 16 --num-layers 1 --cuda 0 --hyp_rotation 0 --dropout 0.7 --weight-decay 0.0001 --margin 0.1 --step_lr_gamma 0.8


'''

#### Directory: 
       data                     datasets files 
       layers                   includes a centroid-based classification and layers 
       log                      path to save logs  
       manifolds                includes the Lorentz manifold 
       model_save               path to save trained models  
       models                   encoder for graph embedding and decoder for post-processing  
       utils                    utility modules and functions  
       config.py                config file  
       train.py                 run this file to start the training  
       requirements.txt         requirements file  
       README.md                README file  

#### optional arguments:  
    --task                  which tasks to train on, 'lp' or 'nc'  
    --dataset               which dataset to use, 'disease_lp' or 'disease_nc'  
    --model                 which model to use   
    --lr                    learning rate for Euclidean parameters   
    --normalize-feats       whether to normalize input node features  
    --epochs                maximum number of epochs  
    --step_lr_reduce_freq   step_size for StepLR scheduler   
    --feature_dim           feature_dim input feature dimensionality  
    --dim                   embedding dimensionality  
    --num-layers            number of hidden layers  
    --patience              patience for early stopping  
    --num_centroid          number of centroids used for the node classification task  
    --margin                margin for margin loss function
    --hyp_rotation          boolean to whether use hyperbolic rotation or not


