# LucidPPN: Unambiguous Prototypical Parts Networks for User-centric Interpretable Computer Vision

This repository is the official implementation of [LucidPPN: Unambiguous Prototypical Parts
Networks for User-centric Interpretable Computer
Vision](). 

It is build on top of two other repositories:
- https://github.com/M-Nauta/PIPNet
- https://github.com/robertdvdk/part_detection

## Requirements

To install requirements:

```setup
conda create --name lucidppn --file requirements.txt
```

To prepare datasets:
- download CUB from https://www.vision.caltech.edu/datasets/cub_200_2011/,
- download CARS from https://www.kaggle.com/datasets/jessicali9530/stanford-cars-dataset,
- download FLOWER from https://www.robots.ox.ac.uk/~vgg/data/flowers/102/,
- download DOGS from http://vision.stanford.edu/aditya86/ImageNetDogs/,
- run `preprocess_data/prepare_dogs.py` to organize DOGS,
- run `preprocess_data/prepare_flowers.py` to organize FLOWER,
- convert CARS into ImageDataset format i.e into two directories: `train/` and `test/` with subdirectory for each class
- cutout CUB images as in https://github.com/cfchen-duke/ProtoPNet,
- set dataset locations in `PIPNet/util/data.py` and `MetiNet/util/data.py` and `run_training.sh` files.

## Training and evaluation

To train and evaluate the LucidPPN run `MetiNet/run_training.sh` by uncommenting desired experiments.
To train and evaluate the PIP-Net run `PIPNet/run_training.sh` by uncommenting desired experiments.

For LucidPPN, remember to first run `part_detection/run_training.sh` to generate segmentation masks.
## Pre-trained Models

Pre-trained models to reproduce the main results in paper are in `pretrained/`. (Will be added later as there is a 100MB limit on openreview)

## License
See `LICENSE`.
