from dataset import get_dataset
from utils import setup_arguments_parser, normalise_and_trim
from comparison import compare_optimizers


def main(args):
    a, b = get_dataset(args.dataset)
    a, b = normalise_and_trim(a, b, args.n_workers)

    num_rows, dim = a.shape
    print(f'Dataset dimensionality: {dim}')
    print(f'Number of rows: {num_rows}')
    print(f'Number of workers: {args.n_workers}')
    print(f'Per worker: {int(num_rows // args.n_workers)}')

    compare_optimizers(a, b, args)


if __name__ == '__main__':
    main(setup_arguments_parser())
