# Tensorboard-like smoothing
def smooth(scalars, weight):  # Weight between 0 and 1
  last = scalars[0]  # First value in the plot (first timestep)
  smoothed = list()
  for point in scalars:
    smoothed_val = last * weight + (1 - weight) * point  # Calculate smoothed value
    smoothed.append(smoothed_val)  # Save it
    last = smoothed_val  # Anchor the last smoothed value
  return smoothed

def smoothing_fn(df):
  df['mean_episode_return'] = smooth(df.mean_episode_return.values, 0.9) # don't care other columns
  return df

def add_params_column(df, params):
  for k, v in params.items():
    df[k] = str(v)
  return df

def align_steps(x):
  return (int(x) // 100000) * 100000


def read_eval_csv(path):
  with file.Open(path, 'r') as f:
   t = pd.read_csv(f)   
   t = t.drop(t.query('actor_step == "actor_step"').index) # remove occasional extra header row
   t = t.astype('float32')
   t = smoothing_fn(t)
   t = add_params_column(t, params)
   t['aligned_steps'] = df.actor_step.transform(align_steps)   
  return t

def plot_df(df, raw=False):
  if raw:  # unnormalized score
    return sns.relplot(data=df, x='aligned_steps', y='rewards', col='sub_env_name', hue='label', col_wrap=4, ci='sd', kind='line', height=2.5, facet_kws={'sharey': False, 'sharex': True})
  else:  
    return sns.relplot(data=df, x='aligned_steps', y='mean_episode_return', col='sub_env_name', hue='label', col_wrap=4, ci='sd', kind='line', height=2.5, facet_kws={'sharey': False, 'sharex': True})