# Imputation Assisted Multi-Agent Reinforcement Learning (IA-MARL)

This directory contains implementations of IA-MARL.
We modify and use [multi-agent particle environment](https://github.com/openai/multiagent-particle-envs) for the experiment. The modified environments are in `./environments`

## Training command
MARL training using IA-MARL when training data missing  probability is 0.1
```shell
$ python main.py --model_name IA-MARL_GAIN --drop_p 0.1 --n_epi 10000 --pre_epi 10000
```

### Command inputs:
- drop_p: training data missing probability (0 <= drop_p < 1.0)
- n_epi: number of steps for the training
- pre_epi: number of pretraining steps for GAIN
- random_imputation: use random imputation instead of GAIN (option for ablation study)
- ablabtion: training without mask-based update, i.e., Simple-IA-MARL instead of IA-MARL (option for the ablation study) 
See `config.py`to see all options.

## Evaluation code
Script to reproduce ablation study (for the fast reproduction, one random seed is used.)
```shell
$ ./run_example.sh
```

## Requirements
gym==0.15.7
numpy==1.19.5
torch==1.7.1
tqdm==4.56.0
[Multi-Agent Particle Environments (MPE)](https://github.com/openai/multiagent-particle-envs)

