import numpy as np
from matplotlib import pyplot as plt

name = ['MADDPG', 'DDPG', 'IA-MARL_GAIN', 'IA-MARL_Random']
# To show the results with Simple-IA-MARL use the following variable
# name = ['MADDPG', 'DDPG', 'IA-MARL_GAIN', 'IA-MARL_Random',
#        'Simple-IA-MARL_GAIN', 'Simple-IA-MARL_Random']

steps = np.arange(0, 10001, 500)
for n in name:
    data = np.load('./model/simple_speaker_listener/{}_R1.npy'.format(n))
    # plot average rewards of agent 0
    plt.plot(steps, data[:,0], label='{}'.format(n))
plt.legend()
plt.show()
