import numpy as np

class RewardPanel:
    def __init__(self, size = None):
        if size == None:
            size = 100
        self.panel_size = size
    def query_panel(self, reward, reward_perturb):
        prob = 1 / (1 + np.exp(reward - reward_perturb))
        result = np.random.choice([1,0], p=[prob, 1-prob], size=self.panel_size)
        return result, prob

class RewardPanelLinear:
    def __init__(self, size = None):
        if size == None:
            size = 100
        self.panel_size = size
    def query_panel(self, reward, reward_perturb):
        prob = np.maximum(np.minimum((reward_perturb - reward) / 50 + 0.5, 1), 0)
        result = np.random.choice([1,0], p=[prob, 1-prob], size=self.panel_size)
        return result, prob

class RewardPanelWeibull:
    def __init__(self, size = None):
        if size == None:
            size = 100
        self.panel_size = size
    def query_panel(self, reward, reward_perturb):
        prob = np.exp2(- np.exp2(reward - reward_perturb))
        result = np.random.choice([1,0], p=[prob, 1-prob], size=self.panel_size)
        return result, prob