
from gym.envs.registration import register

def register_custom_envs():
    
    register(
        id="Ant-v3",
        entry_point='envs.mujoco.ant_v3:AntEnv',
        max_episode_steps=200,
        reward_threshold=6000,
    )

    register(
        id="Point-v1",
        entry_point='envs.mujoco.point_v1:PointEnv',
        max_episode_steps=200,
        reward_threshold=6000,
    )
    
    register(
        id="Hopper-v2",
        entry_point="envs.mujoco:HopperEnv",
        max_episode_steps=200,
        reward_threshold=3800.0,
    )

    register(
	    id="Hopper-v3",
	    entry_point="envs.mujoco.hopper_v3:HopperEnv",
	    max_episode_steps=400,
	    reward_threshold=3800.0,
	)
	
    register(
        id="Hopper-obstacle-v3",
        max_episode_steps=2500,
        entry_point="envs.mujoco.hopper_obstacle_v3:HopperObstacleEnv",
    )

    register(
        id="Walker2d-v2",
        max_episode_steps=300,
        entry_point="envs.mujoco:Walker2dEnv",
    )

    register(
        id="Walker2d-v3",
        max_episode_steps=400,
        entry_point="envs.mujoco.walker2d_v3:Walker2dEnv",
    )

    register(
        id="Walker2d-obstacle-v3",
        max_episode_steps=2500,
        entry_point="envs.mujoco.walker2d_obstacle_v3:Walker2dObstacleEnv",
    )

    register(
        id="Humanoid-v2",
        entry_point="envs.mujoco:HumanoidEnv",
        max_episode_steps=400,
    )

    register(
        id="Humanoid-v3",
        entry_point="envs.mujoco.humanoid_v3:HumanoidEnv",
        max_episode_steps=400,
    ) 

    register(
        id="Halfcheetah-v3",
        entry_point="envs.mujoco.half_cheetah_v3:HalfCheetahEnv",
        max_episode_steps=200,
    ) 

    register(
        id="Halfcheetah-obstacle-v3",
        entry_point="envs.mujoco.half_cheetah_obstacle_v3:HalfCheetahObstacleEnv",
        max_episode_steps=600,
    )

    register(
        id="InvertedPendulum-v2",
        entry_point="envs.mujoco.inverted_pendulum_v2:InvertedPendulumEnv",
        max_episode_steps=200,
    )
    
    register(
        id="InvertedDoublePendulum-v2",
        entry_point="envs.mujoco.inverted_double_pendulum_v2:InvertedDoublePendulumEnv",
        max_episode_steps=1000,
        reward_threshold=9100.0,
    )

