# INDOOR15K Dataset
## Overview
The INDOOR15K Dataset consists of images and their associated metadata designed for benchmarking indoor image geolocation systems.

## Data Format
The dataset is provided in CSV format (INDOOR15K.csv) with each row representing an image and its associated metadata. Below is a detailed description of each column in the dataset. 

## Columns [FULL benchmark including full reverse geolocation information, Phash, SAM segments etc is made accessible via a repo]
- _id: A unique identifier for each image in the dataset.
- title: The title or description of the image.
- latitude: The geographic latitude where the image was taken.
- longitude: The geographic longitude where the image was taken.
- tags: A set of user entered keywords or tags associated with the image.
- url: The URL where the image can be accessed.
- indoor_prob: A score representing the confidence that the image is taken indoors (range 0.5 to 1, where 1 is high confidence).
- mitindoor_scene: Scene classification based on the MIT Indoor Scene dataset.
- places365_scene: Scene classification based on the Places365 model.
- description: A textual description of the image.
- reverse_geo.address.suburb: The suburb name where the image was taken, based on reverse geocoding.
- reverse_geo.address.city: The city name where the image was taken, based on reverse geocoding.
- reverse_geo.address.country: The country where the image was taken, based on reverse geocoding.
- reverse_geo.address.region: The region or state where the image was taken, based on reverse geocoding.
- date_upload: The date the image was uploaded.
- date_taken: The date the image was captured.
- last_update: The timestamp of the last update made to the image metadata.
- owner_name: The name of the image's owner or uploader.

