
# Dataset Downloader

This helper code allows you to download images from the dataset CSV file containing image URLs. 

## Usage

### Requirements
- Python 3.x
- `requests` library
- `pandas` library

Install the necessary dependencies using `requirements.txt`:
```
pip install -r requirements.txt
```

### Running the download Script

To run the script, use the following command:

```
python download_images.py <csv_file> <download_dir> --url_column <url_column> --threads <number_of_threads> --delay <seconds_between_requests>
```

- `<csv_file>`: The CSV file containing image URLs.
- `<download_dir>`: Directory where the images will be downloaded.
- `--url_column`: The column in the CSV that contains the image URLs (default: `url`).
- `--threads`: The number of threads to use for downloading (default: `1`).
- `--delay`: Delay between requests in seconds to avoid overloading servers (default: `1` second).

### Example

```
python download_images.py test_dataset.csv images --threads 4 --delay 2
```

This will download the images into the `images` directory using 4 threads, with a 2-second delay between requests to each server.

### Links to population and land area information

Population - https://data.worldbank.org/indicator/SP.POP.TOTL
Land Area - https://data.worldbank.org/indicator/AG.LND.TOTL.K2


## License

MIT License
