## Model architecture, property_fn and train_model function for the HELOC dataset
import torch
from torch.utils.data import Dataset
from data.utils import load_openxai_dataset

class HELOC(Dataset):
    def __init__(self, train=True, download=False, scale='minmax'):
        self.name = 'heloc'
        self.data, self.targets = load_openxai_dataset(name='heloc', train=train, download=download, scale=scale)
        self.classes = torch.unique(self.targets)

    def __len__(self):
        return len(self.data)

    def __getitem__(self, idx):
        idx = idx.tolist() if isinstance(idx, torch.Tensor) else idx
        return (self.data[idx], self.targets[idx])
    
    def get_num_samples(self):
        return self.data.shape[0]
        
    def get_num_features(self):
        return self.data.shape[1]
