from torch.utils.data import Dataset
import torchvision
from torchvision import transforms
import os

class MNIST(Dataset):
    def __init__(self, train=True, download=False):
        self.name = 'mnist'
        self.train = train
        datasets_dir = os.path.abspath(__file__).split('data/')[0] + 'data/'
        path = f'{datasets_dir}/mnist/data/'
        self.dataset = torchvision.datasets.MNIST(root=path, train=train,
                                                  download=download, transform=transforms.ToTensor())

    def __len__(self):
        return len(self.dataset)

    def __getitem__(self, idx):
        return self.dataset[idx]