import os
import json
from itertools import product

def save_json(data, filename):
    with open(filename, 'w') as f:
        json.dump(data, f, indent=4)

def load_json(filename, convert_keys_to_int=False):
    with open(filename, 'r') as f:
        data = json.load(f)
    return {int(k): v for k, v in data.items()} if convert_keys_to_int else data

def run_sbatch(filename: str,
               options: str,
               job_name: str,
               log_file: str,
               time_hrs: str = '3',
               gpu: bool = False,
               gpu_name: str = None):
    # Create temp file, and place common to run inside it
    os.system('rm -f ' + log_file)
    main_command = f'FILENAME=$(mktemp) ; echo "#!/bin/sh \n python {filename} {options}" > $FILENAME'
    
    # Sbatch options
    gpu_str = f'{gpu_name}:' if gpu_name is not None else ''
    compute_str = f' -p gpu --gres=gpu:{gpu_str}1 --mem=40gb' if gpu else ' --mem-per-cpu=32gb'
    sbatch_options = f'sbatch{compute_str} --time=0-0{time_hrs}:00 --error={log_file}.err --output={log_file}.out --job-name={job_name} $FILENAME'
    # print(sbatch_options)
    
    # Run two commands above in order; remove temp file after
    full_cmd = f'{main_command} ; {sbatch_options} ; rm $FILENAME'
    os.system(full_cmd)

def dict2options(settings):
    keys, opts = [], []
    for k in settings:
        keys.append(k); opts.append(settings[k])

    exp_list = list(product(*opts))
    options_str, name_str = [], []
    for option in exp_list:
        temp_str, temp_name_str = '', ''
        for (k,i) in zip(keys, option):
            if type(i) == bool:
                temp_str += f'--{k} ' if i else ''
                temp_name_str += f'{k}_' if i else ''
            else:
                temp_str+=f'--{k}={i} '
                temp_name_str += f'{i}_'
        options_str.append(temp_str)
        name_str.append(temp_name_str[0:-1])
    return options_str, name_str