from .abstract_classes import DataAttributor
from .influence_gauss_newton import InfluenceGNAttributor
from .influence_lissa import InfluenceLissaAttributor
from .influence_conjugate_grad import InfluenceCGAttributor
from .trak import TrakAttributor
from .tracin import TracInAttributor


from .influence_lissa_hf import InfluenceLissaAttributorHF
# from .tracin_hf import TracInAttributorHF
attributors_dict = {
    'random': RandomAttributor,
    'leave_one_out': LeaveOneOutAttributor,
    'influence_cg': InfluenceCGAttributor,
    'influence_lissa': InfluenceLissaAttributor,
    'influence_gn': InfluenceGNAttributor,
    'datamodels': DataModelsAttributor,
    'trak': TrakAttributor,
    'tracin': TracInAttributor,
    'group_tracin': GroupTracInAttributor,
    # QNLI
    'influence_lissa_hf': InfluenceLissaAttributorHF,
}