# FEMNIST
SEEDS="0 1 2"
SHARED_ARGS="\
    --dataset femnist \
    --num_epochs 200 \
    --eval_on val test \
    --support_size 20 
    --seeds ${SEEDS} \
    --meta_batch_size 5 \
    --epochs_per_eval 10 \
    --optimizer sgd \
    --learning_rate 1e-4 \
    --weight_decay 1e-4"

N_CONTEXT_CHANNELS=1  # for CML

python run.py --exp_name erm-fm --algorithm ERM ${SHARED_ARGS}
python run.py --exp_name arm-cml-fm --algorithm ARM-CML --n_context_channels ${N_CONTEXT_CHANNELS} ${SHARED_ARGS}
python run.py --exp_name arm-bn-fm --algorithm ARM-BN  ${SHARED_ARGS}
python run.py --exp_name cxda-fm --algorithm CXDA ${SHARED_ARGS}
python run.py --exp_name cxda-sup-fm --algorithm CXDA --supervised 1 ${SHARED_ARGS}


# CIFAR-10-C
SEEDS="0 1 2"
SHARED_ARGS="\
    --dataset cifar-c \
    --num_epochs 100 \
    --eval_on val test \
    --support_size 20 
    --seeds ${SEEDS} \
    --meta_batch_size 5 \
    --epochs_per_eval 10 \
    --optimizer sgd \
    --learning_rate 1e-2 \
    --weight_decay 1e-4"

N_CONTEXT_CHANNELS=3  # for CML

python run.py --exp_name erm-cc --algorithm ERM ${SHARED_ARGS}
python run.py --exp_name arm-cml-cc --algorithm ARM-CML --n_context_channels ${N_CONTEXT_CHANNELS} ${SHARED_ARGS}
python run.py --exp_name arm-bn-cc --algorithm ARM-BN  ${SHARED_ARGS}
python run.py --exp_name cxda-cc --algorithm CXDA ${SHARED_ARGS}
python run.py --exp_name cxda-sup-cc --algorithm CXDA --supervised 1 ${SHARED_ARGS}


# TinyImageNet-C
SEEDS="0 1 2"
SHARED_ARGS="\
    --dataset tinyimg \
    --num_epochs 50 \
    --eval_on val test \
    --support_size 20 
    --seeds ${SEEDS} \
    --meta_batch_size 5 \
    --epochs_per_eval 5 \
    --model resnet50 \
    --optimizer sgd \
    --learning_rate 1e-2 \
    --weight_decay 1e-4"

N_CONTEXT_CHANNELS=3  # for CML

python run.py --exp_name erm-ti --algorithm ERM ${SHARED_ARGS}
python run.py --exp_name arm-cml-ti --algorithm ARM-CML --n_context_channels ${N_CONTEXT_CHANNELS} ${SHARED_ARGS}
python run.py --exp_name arm-bn-ti --algorithm ARM-BN  ${SHARED_ARGS}
python run.py --exp_name cxda-ti --algorithm CXDA ${SHARED_ARGS}
python run.py --exp_name cxda-sup-ti --algorithm CXDA --supervised 1 ${SHARED_ARGS}