# Feed-Forward Latent Domain Adaptation

Abstract: We study the highly practical but comparatively under-studied problem of latent-domain adaptation, where a source model should be adapted to a target dataset that contains a mixture of unlabelled domain-relevant and domain-irrelevant examples. Furthermore, motivated by the requirements for data privacy and the need for embedded and resource-constrained devices of all kinds to adapt to local data distributions, we focus on the setting of feed-forward source-free domain adaptation, where adaptation should not require access to the source dataset, and also be back propagation-free. Our solution is to meta-learn a network capable of embedding the mixed-relevance target dataset and dynamically adapting inference for target examples using cross-attention. The resulting framework leads to consistent  improvement on strong ERM baselines. We also show that our framework sometimes even improves on the upper bound of domain-supervised adaptation, where only domain-relevant instances are provided for adaptation. This suggests that human annotated domain labels may not always be optimal, and raises the possibility of doing better through automated instance selection.

This repository extends [ARM](https://github.com/henrikmarklund/arm) repository and provides the code for our FEMNIST, CIFAR-C and TinyImageNet-C experiments.

## Environment

Python version: 3.6.5

How to install requirements (mainly `torch`, `tqdm`, `numpy`, `albumentations`):
 - `pip install -r requirements.txt`

## Data

FEMNIST
- The train/val/test data split used in the paper can be found here: https://drive.google.com/file/d/1xvT13Sl3vJIsC2I7l7Mp8alHkqKQIXaa/view?usp=sharing

CIFAR-C
- Test data can be downloaded here: https://zenodo.org/record/2535967#.YCUsMukzZ0s
- The training and validation split used in the paper can be found here: https://drive.google.com/file/d/1blM7LHGR62-dVJjNAScsJMlzeiQS9DX1/view?usp=sharing

TinyImagenet-C
- Test data can be downloaded here: https://zenodo.org/record/2536630#.YCUsBOkzZ0s
- The training and validation split used in the paper can be found here: https://drive.google.com/file/d/13hd39InVa5WqPUpuoJtl9kSSwyDFyFNc/view?usp=sharing

## Experiments

Examples of how to run the experiments are provided here - using FEMNIST. More details are in `all_commands.sh` file.

##### Shared args
```
SEEDS="0"
SHARED_ARGS="--dataset femnist --num_epochs 200 --eval_on val test --support_size 20 --seeds ${SEEDS} --meta_batch_size 5 --epochs_per_eval 10 --optimizer sgd --learning_rate 1e-4 --weight_decay 1e-4"
```

##### ERM
```
python run.py --exp_name erm-fm --algorithm ERM ${SHARED_ARGS}
```

##### ARM-CML
```
python run.py --exp_name arm-cml-fm --algorithm ARM-CML --n_context_channels 1 ${SHARED_ARGS}
```

##### ARM-BN
```
python run.py --exp_name arm-bn-fm --algorithm ARM-BN ${SHARED_ARGS}
```

##### CXDA
```
python run.py --exp_name cxda-fm --algorithm CXDA ${SHARED_ARGS}
```

##### CXDA (supervised)
```
python run.py --exp_name cxda-sup-fm --algorithm CXDA --supervised 1 ${SHARED_ARGS}
```