
## HaPPI: Hadamard PCA based Power Iteration
HaPPI is an advanced KV cache compression technique based on the Hadamard transform, PCA, and Power Iteration. It is designed as a highly efficient and accurate low-rank approximation method within the GEAR framework.

Key features of HaPPI:
*   **Whitening Transform**: It first applies a Whitening transform to the KV cache to reduce the correlation between features, which enhances the effectiveness of a subsequent compression step.
*   **Hadamard Transform**: It utilizes the Fast Walsh-Hadamard Transform (FWHT), a computationally efficient alternative to the basis transform of PCA, to project the data into a new space where the information is more concentrated.
*   **Power Iteration-based PCA**: Instead of computing the full SVD, which can be computationally expensive, `HaPPI` uses Power Iteration to find the principal components (singular vectors) of the covariance matrix of the transformed data. This is a more efficient way to perform low-rank approximation.
*   **Combined Approach**: By combining these techniques, `HaPPI` achieves high compression ratios with minimal accuracy loss.

### How to use happi
You can use `happi` by setting the `--kv_transform` argument to `happi` when running the `evaluation_gsm8k.py` script.

Example:
```bash
python GenerationBench/GenerationTest/evaluation_gsm8k.py \
    --model meta-llama/Llama-3-8b \
    --compress_method PCC_COV_OUTLIER_COMPACT \
    --kv_transform happi \
    --rank 4 \
    --loop 2
```
