# Basics of Syne Tune


This tutorial provides an overview of Syne Tune. You will learn about the most
important concepts of automated hyperparameter tuning, and how to make it work
for your setup.

If you like to run the code linked in this tutorial, please make sure to use
the current `PyPI` release. If you cloned the source repository, this is
obtained as follows:

```bash
git checkout -b basic_tutorial v0.11
```

This gives you a local branch `basic_tutorial`, in which you can play around
with the code.


# Table of Contents

* [Setting up the Problem](basics_setup.md)
* [Random Search](basics_randomsearch.md)
* [Bayesian Optimization](basics_bayesopt.md)
* [Asynchronous Successive Halving and Hyperband](basics_asha.md)
* [Model-Based Asynchronous Successive Halving](basics_mobster.md)
* [Promotion-based Scheduling](basics_promotion.md)
* [SageMaker Back-end](basics_backend.md)
* [Outlook](basics_outlook.md)

[[First Section]](basics_setup.md)
