export CUDA_VISIBLE_DEVICES=1

model_name=TwinsFormer
dataset=PEMS03
seq_len=96

python -u run.py \
  --is_training 1 \
  --root_path ./dataset/PEMS/ \
  --data_path PEMS03.npz \
  --model_id PEMS03_96_12 \
  --model $model_name \
  --data PEMS \
  --features M \
  --seq_len $seq_len \
  --pred_len 12 \
  --e_layers 2 \
  --enc_in 358 \
  --dec_in 358 \
  --c_out 358 \
  --des 'Exp' \
  --d_model 512 \
  --d_ff 1024 \
  --batch_size 32 \
  --learning_rate 0.001 \
  --itr 1 \
  --use_norm 0 >logs/$model_name'_'$dataset'_'$seq_len'_'12.log

python -u run.py \
  --is_training 1 \
  --root_path ./dataset/PEMS/ \
  --data_path PEMS03.npz \
  --model_id PEMS03_96_24 \
  --model $model_name \
  --data PEMS \
  --features M \
  --seq_len $seq_len \
  --pred_len 24 \
  --e_layers 2 \
  --enc_in 358 \
  --dec_in 358 \
  --c_out 358 \
  --des 'Exp' \
  --d_model 512 \
  --d_ff 1024 \
  --batch_size 32 \
  --learning_rate 0.001 \
  --itr 1 \
  --use_norm 0 >logs/$model_name'_'$dataset'_'$seq_len'_'24.log


python -u run.py \
  --is_training 1 \
  --root_path ./dataset/PEMS/ \
  --data_path PEMS03.npz \
  --model_id PEMS03_96_48 \
  --model $model_name \
  --data PEMS \
  --features M \
  --seq_len $seq_len \
  --pred_len 48 \
  --e_layers 2 \
  --enc_in 358 \
  --dec_in 358 \
  --c_out 358 \
  --des 'Exp' \
  --d_model 512 \
  --d_ff 1024 \
  --batch_size 32 \
  --learning_rate 0.001 \
  --itr 1 \
  --use_norm 0 >logs/$model_name'_'$dataset'_'$seq_len'_'48.log


python -u run.py \
  --is_training 1 \
  --root_path ./dataset/PEMS/ \
  --data_path PEMS03.npz \
  --model_id PEMS03_96_96 \
  --model $model_name \
  --data PEMS \
  --features M \
  --seq_len $seq_len \
  --pred_len 96 \
  --e_layers 2 \
  --enc_in 358 \
  --dec_in 358 \
  --c_out 358 \
  --des 'Exp' \
  --d_model 512 \
  --d_ff 1024 \
  --batch_size 32 \
  --learning_rate 0.001 \
  --train_epoch 7 \
  --use_norm 0 >logs/$model_name'_'$dataset'_'$seq_len'_'96.log
