import os
import torch
import numpy as np
import matplotlib.pyplot as plt
from matplotlib.font_manager import FontProperties


methods = ['FOA','SR1', 'SABA', 'BOME', 'F2SA','SHINE1']
results_dir = ''
data_dict = {}

legend_names= {
    'SHINE1': 'SHINE-OPA',
    'FOA': 'qNBO(BFGS)',
    'SABA': 'SABA',
    'BSG_1': 'BSG1',
    'F2SA': 'F2SA',
    'BOME': 'BOME',
    'SR1':'qNBO(SR1)',
   
}

for method in methods:
    data = torch.load(os.path.join(results_dir, f"{method}.pt"))

    
    avg_running_times = np.mean(data['all_running_times'], axis=0)
    avg_test_accs = np.mean(data['all_test_accs'], axis=0)
    std_test_accs = np.std(data['all_test_accs'], axis=0) 

    
    data_dict[method] = {
        'avg_running_times': avg_running_times,
        'avg_test_accs': avg_test_accs,
        'std_test_accs': std_test_accs
    }

style_dict = {
    'SHINE1': {'color': 'green', 'linestyle': '-', 'linewidth': 4},
    'FOA': {'color': '#D02020', 'linestyle': '-', 'linewidth': 5.5},  
    'SR1': {'color': '#0000CC', 'linestyle': '-', 'linewidth': 4},  
    'SABA':{'color': 'purple', 'linestyle': '-.', 'linewidth': 1},
    'F2SA': {'color': 'C0', 'linestyle': '--', 'linewidth': 1 },
    'BOME': {'color': 'C9', 'linestyle': '-', 'linewidth': 3.2, 'alpha': 0.6},
    'BSG_1': {'color': 'green', 'linestyle': 'dotted' ,'linewidth': 4, 'alpha': 0.8}
}


max_time_to_plot = 3
plt.figure(figsize=(6, 4.5))

for method in methods:
    data = data_dict[method]
    indices_to_plot = data['avg_running_times'] < max_time_to_plot
    
    avg_acc = data['avg_test_accs'][indices_to_plot]
    time_data = data['avg_running_times'][indices_to_plot]
    std_dev_acc = data['std_test_accs'][indices_to_plot] 

    plt.plot(time_data, avg_acc, label=method, **style_dict[method])
    
    plt.fill_between(time_data, avg_acc - std_dev_acc, avg_acc + std_dev_acc, alpha=0.4, color=style_dict[method]['color'])

plt.xlabel('Running time (s)', fontsize=20)
plt.ylabel('Test accuracy', fontsize=20)
plt.xticks(fontsize=20)
plt.xticks(range(0, 3, 1))
plt.yticks(fontsize=20)
plt.xlim(-0.05,2)
ax=plt.gca()
ax.set_xticks(range(0, 3, 1))



#plt.grid(True)
plt.savefig('dcta.pdf', dpi=300, bbox_inches='tight')



legend_font = FontProperties(weight='heavy', size=30)
plt.figure(figsize=(6, 1))  
handles = [plt.Line2D([], [], color=style_dict[method]['color'], 
                      linestyle=style_dict[method]['linestyle'], 
                      linewidth=7,  
                      label=legend_names[method]) for method in methods]
plt.legend(handles=handles, ncol=6, fontsize=30, prop=legend_font, loc='center')
plt.axis('off')  
plt.savefig('plegend.pdf', dpi=300, bbox_inches='tight')

