import numpy as np
from scipy import optimize
from scipy.sparse import eye
from sklearn.utils.extmath import safe_sparse_dot

def CG(A, b, x, num_steps):
    r = b - A(x) 
    p = r.copy() 
    rs_old = np.dot(r, r)  
    
    for _ in range(num_steps):
        Ap = A(p)
        alpha = rs_old / np.dot(p, Ap)  
        x = x + alpha * p
        r = r - alpha * Ap
        rs_new = np.dot(r, r)  
        if np.sqrt(rs_new) < 1e-10:  
            break
        p = r + (rs_new / rs_old) * p
        rs_old = rs_new
    
    return x