#!/bin/bash

function func_basic {
    batch_size=$1
    num_data=$2
    min_objects=$3
    max_objects=$4
    output_image_dir=$folder_out'/images/'$min_objects'_'$max_objects
    output_scene_dir=$folder_out'/scenes/'$min_objects'_'$max_objects
    output_blend_dir=$folder_out'/blendfiles/'$min_objects'_'$max_objects
    for (( start_idx=0; start_idx<num_data; start_idx=start_idx+batch_size )); do
        blender --background -noaudio --python $path_run -- \
            --seed $start_idx \
            --start_idx $start_idx \
            --num_images $batch_size \
            --min_objects $min_objects \
            --max_objects $max_objects \
            --output_image_dir $output_image_dir \
            --output_scene_dir $output_scene_dir \
            --output_blend_dir $output_blend_dir \
            --width 128 \
            --height 128 \
            --use_gpu \
            --use_optix \
            --min_dist 0.1 \
            --save_blendfiles
    done
}

export PYTHONHASHSEED=0
export CUDA_VISIBLE_DEVICES=0

path_run='render_images.py'
folder_out='./output'

batch_size=5
num_data=5200
min_objects=3
max_objects=6
func_basic $batch_size $num_data $min_objects $max_objects

# batch_size=1
# num_data=120
# min_objects=7
# max_objects=10
# func_basic $batch_size $num_data $min_objects $max_objects
