#!/bin/bash

export CUDA_LAUNCH_BLOCKING=1
export CUDA_VISIBLE_DEVICES=0

DATANAME=${1:-'clevr_a'}
DATAPATH=${2:-'data/clevr_a_multi_20.h5'}
MODELNAME=${3:-'lorm'}

python -m torch.distributed.launch --nproc_per_node 1  --master_port 20500 src/train.py \
    --data_name $DATANAME --data_path $DATAPATH \
    --model_name $MODELNAME \
    --batch_size 24 --slot_size 64 \
    --single_view