from pytorch_lightning.callbacks import Callback, ModelCheckpoint


## Define own callbacks here




def get_callbacks(cfg):
    
    callacks = []

    if 'checkpointing' in cfg.callbacks:
        # Saves the top k checkpoints according to the test metric throughout
        # training.
        ckpt = ModelCheckpoint(
            filename="{epoch}-{val_loss:.4f}",
            save_top_k=cfg.callbacks.checkpointing.save_top_k,
            monitor="val_loss",
            mode="min",
            auto_insert_metric_name=True
        )
        callacks.append(ckpt)

    # TODO add your own callbacks here
    
    return callacks