"""
MoE Knowledge Editing Package

A modular implementation for knowledge editing in Mixture of Experts models,
specifically designed for Qwen3-30B-A3B.
"""

from .utils import EditRequest, pre_edit_prob
from .manager import HookManager, ProjectionMatrixManager, DownProjCollector
from .stats_collector import Qwen3MoEStatisticsCollector
from .optim import BlockCoordinateDescent
from .config import MoEEditConfig
from .editor import Qwen3MoEKnowledgeEditor
from .multi_layer_editor import MultiLayerMoEKnowledgeEditor

__version__ = "1.0.0"
__all__ = [
    "Qwen3MoEKnowledgeEditor",
    "MultiLayerMoEKnowledgeEditor",
    "EditRequest",
    "HookManager",
    "ProjectionMatrixManager",
    "DownProjCollector",
    "Qwen3MoEStatisticsCollector",
    "BlockCoordinateDescent",
    "pre_edit_prob",
    "MoEEditConfig"
]
