import random


def sample_from_list(l):
    return l[random.randint(0, len(l)-1)]
def sample_conv():
    return sample_from_list([0, 1])
def sample_norm():
    return sample_from_list([0, 2])
def sample_up():
    return sample_from_list([0, 1, 2])
def sample_shortcut():
    return sample_from_list([0, 1])
def sample_skip():
    return sample_from_list([0, 1])

def sample_arch():
    return [sample_conv(), sample_norm(), sample_up(), sample_shortcut(),
            sample_conv(), sample_norm(), sample_up(), sample_shortcut(), sample_skip(),
            sample_conv(), sample_norm(), sample_up(), sample_shortcut(), sample_skip()]

for _ in range(4):
    arch = sample_arch()
    str_arch = '[' + ','.join([str(n) for n in arch]) + ']'

    for reg in [0, 0.01]:
        for n_adv in [1, 2]:
             command = f'python main.py with regularizer_strength={reg} n_critic={n_adv} instance_norm=True sampled_architecture={str_arch}'
             print('COMMAND="' + command +'"')
