from openai import OpenAI
import json

# model_name = "gpt-4o-2024-08-06"
model_name = "gpt-4o-mini-2024-07-18"

client = OpenAI(api_key = "")

batch_ids = []

with open(f"record_gpt_requests_{model_name}.txt") as f:
    for line in f:
        batch_ids.append((line.strip().split(" ")[-1]).strip())

for i, batch_id in enumerate(batch_ids):
    batch = client.batches.retrieve(batch_id)
    if batch.status == "completed":
        output_file_id = batch.output_file_id
        file_response = client.files.content(output_file_id)
        with open(f"benchmark/gpt_generated_sub_sci/{model_name}/mini_batch_{i}.json", "w") as wf:
            wf.write(file_response.text)
    else:
        print('-'*30)
        print(f"Batch {batch_id} is not completed yet.")
        print(batch)